import java.util.Collection;
import java.util.Arrays;

public class TesteBibli {

    public static Collection<Document> testeCritere(Bibliotheque bib, Critere c, int num)
	          throws ErreurCritere {
        // Ajouter a la classe Bibliotheque une methode select qui
        // renvoie la collection des documents de la bibliotheque
        // qui valident le critere passe en parametre.
        Collection<Document> res = bib.select(c);
        System.out.println("Resultat de la requete " + num + ": "
                           + res.size() + " reponses");
        return res;
    }

    public static void main(String[] args) throws ErreurCritere {
        Bibliotheque bib = new Bibliotheque();
        Livre l1 = new Livre("L1", "a1", "e1", 2000);
        Livre l2 = new Livre("L2", "a1", "e1", 2000);
        Livre l3 = new Livre("L3", "a2", "e2", 2010);
        Livre l4 = new Livre("L4", "a3", "e2", 2010);
        Livre l5 = new Livre("L5", "a1", "e2", 2005);
        Livre l6 = new Livre("L6", "a33", "e2", 2000);
        LivreImage li7 = new LivreImage("Journal des Mickeys", "a33", "e2", 2000);
        Revue r1 = new Revue("R1", "e1", 2000, 1);
        Revue r2 = new Revue("R2", "e2", 2000, 10);

        Document d = l6;

        bib.add(l1); bib.add(l2); bib.add(l3); bib.add(l4); bib.add(l5);
        bib.add(l6);
        bib.add(li7);
        bib.add(r1); bib.add(r2);

        bib.liste();

        Critere y2000 = new DateComp(2000);
        Critere tR1 = new TitleComp("R1");

        if (y2000.match(l1) && tR1.match(r1) && y2000.match(d)) {
            System.out.println("Premiers tests de criteres ok");
        }

        Critere cl = new AuthorComp("a3");
        Critere cl2 = new AuthorComp("a33");
        if (cl.match(l4)) { System.out.println("Test de cl ok"); }
        if (! cl2.match(l4)) { System.out.println("Test de cl2 ok"); }

        Critere cr = new NumberComp(10);
        if (cr.match(r2) && ! cr.match(r1)) {
            System.out.println("Test de cr ok");
        }
        /*
        CritereCompose c1 = new And(); //y=2000 && titre=R1,
	    c1.addCritere(y2000); c1.addCritere(tR1);
    

	    CritereCompose c2 = new Or();
	    c2.addCritere(y2000); c2.addCritere(tR1);
	    c2.addCritere(cl2);

        CritereCompose cNot = new Not(c2);

        CritereCompose cands2 = new And();
        cands2.addCritere(cl); cands2.addCritere(y2000);
        */

        /* Partie B
        Observateur o1 = new Observateur();
        Observateur o2 = new Observateur();

        System.out.println("Ajout des observateurs");

        o1.add(Arrays.asList(new Document[]{r1, r2, l1, l2, l6}));
        o2.add(Arrays.asList(new Document[]{l3, l4, l6}));

       for(Document o : testeCritere(bib, c1, 1)) { //select R1
            System.out.println(o);
        }
        System.out.println();

        for(Document o : testeCritere(bib, c2, 2)) { //select L6,L1,L2,R1,R2
            System.out.println(o);
        }
        System.out.println();

        for(Document l : testeCritere(bib, cl, 3)) { //select L4
            System.out.println(l.getTitre());
        }
        System.out.println();

        for(Document l : testeCritere(bib, cands2, 4)) { //select 0
            System.out.println(l.getTitre());
        }
        System.out.println();

        for(Document l : testeCritere(bib, cNot, 5)) { //select L3 L4 L5
            System.out.println(l.getTitre());
        }
        System.out.println();

        System.out.println("\nResultats pour o1: ");
        o1.liste();

        System.out.println("\nResultats pour o2: ");
        o2.liste();
        */
    }
}
