import java.util.Collection;
import java.util.ArrayList;

public class TesteBibli {

    public static void main(String[] args) throws ErreurCritere {
        Bibliotheque bib = new Bibliotheque();
        Livre l1 = new Livre("L1", "a1", "e1", 2000);
        Livre l2 = new Livre("L2", "a1", "e1", 2000);
        Livre l3 = new Livre("L3", "a2", "e2", 2010);
        Livre l4 = new Livre("L4", "a3", "e2", 2010);
        Livre l5 = new Livre("L5", "a1", "e2", 2005);
        Livre l6 = new Livre("L6", "a33", "e2", 2000);
        LivreImage li7 = new LivreImage("Journal des Mickeys", "a33", "e2", 2000);
        Revue r1 = new Revue("R1", "e1", 2000, 1);
        Revue r2 = new Revue("R2", "e2", 2000, 10);

        Document d = l6;

        bib.add(l1); bib.add(l2); bib.add(l3); bib.add(l4); bib.add(l5);
        bib.add(l6);
        bib.add(li7);
        bib.add(r1); bib.add(r2);

        bib.liste();

        Critere<Document> y2000 = new DateComp(2000);
        Critere<Document> tR1 = new TitleComp("R1");

        if (y2000.match(l1) && tR1.match(r1) && y2000.match(d)) {
            System.out.println("Premiers tests de criteres ok");
        }

        Critere<Livre> cl = new AuthorComp("a3");
        Critere<Livre> a33 = new AuthorComp("a33");
        if (cl.match(l4)) { System.out.println("Test de cl ok"); }
        if (! a33.match(l4)) { System.out.println("Test de cl2 ok"); }

        Critere<Revue> cr = new NumberComp(10);
        if (cr.match(r2) && ! cr.match(r1)) {
            System.out.println("Test de cr ok");
        }

        //ce qui suit ne compile pas, ce qui est normal
        //cl.match(r1);

        And<Document> c1 = new And<Document>();
        c1.addCritere(y2000); c1.addCritere(tR1);
        // Ne compile pas car cl est un Critere<Livre> et non pas un Critere<Document>
        // c1.addCritere(cl);

        Or<Livre> c2 = new Or<Livre>();
        c2.addCritere(y2000); c2.addCritere(tR1);
        c2.addCritere(a33);

        Not<Livre> cNot = new Not<Livre>(c2);

        And<Livre> cands2 = new And<Livre>();
        cands2.addCritere(cl); cands2.addCritere(y2000);

        // a completer avec vos propres tests
        /*
        ArrayList<Livre> col1 = ... ;
        ArrayList<Document> col2 = ... ;
        ArrayList<LivreImage> col3 = ... ;

        ArrayList<Livre> r1 = Bibliotheque.filtre(col1, cl); // OK
        ArrayList<Livre> r2 = Bibliotheque.filtre(col2, cl); // KO
        ArrayList<Livre> r3 = Bibliotheque.filtre(col3, cl); // OK
        */
    }

}
