/*
 * Copyright (c) 1998 Michel Beaudouin-Lafon, mbl@lri.fr
 *
 *	Programme de dmonstration du package ThreeD.
 */

import java.applet.Applet;
import java.awt.Event;
import java.awt.Button;
import java.awt.Label;
import java.net.URL;

import ThreeD.*;

/** Cette classe tend un Model3D pour permettre la manipulation du modle par un Control3D.
 *	Si l'on veut faire des manipulations dans le repre local de l'objet,
 *	changer rotateView en rotateLocal et translateView en translateLocal.
 */
class Model extends Model3D implements Control3DListener {
	
    Model (URL base, String name) {
	super (base, name);
    }

    /** Mthode appele par Control3D lorsque l'on utilise le contrleur de rotation. */
    public void rotated (double alpha, Vector3D axis) {
    	rotateView (alpha, axis);
    }
    
    /** Mthode appele par Control3D lorsque l'on utilise le contrleur de translation. */
    public void translated (Vector3D tvec) {
    	translateView (tvec);
    }
}
/** Applet qui affiche un objet, le repre de la scne et un contrleur permettant 
 *	de manipuler l'objet.
 */
public class Demo extends Applet {

    View3D view;	// le widget qui va contenir la vue
    Button resetView;	// le bouton qui permet de recentrer la vue
    
    /** Initialiser l'applet : charger les modeles, creer la vue et l'interface */
    public void init () {
	// regarder s'il y a un parametre qui spcifie l'chelle
	double scale = 1;
	try {
	    scale = Double.valueOf(getParameter("scale")).floatValue();
	} catch (Exception e) {
	}
	
    	// rcuprer le nom du modle dans un paramtre pass  l'applet
	String mdname = getParameter("model");
	
	// ou sinon utiliser un cube
	if (mdname == null)
	    mdname = "applet/cube.obj";
	   
	// forcer la taille a 660x450 si elle n'est pas definie
	resize (size().width <= 20 ? 600 : size().width,
	        size().height <= 20 ? 450 : size().height);
	
	// creer la vue 3D
	view = new View3D (scale);
	add (view);
	
	// creer le modele et le mettre dans la vue
	Model obj = new Model (getDocumentBase(), mdname);
	view.addModel (obj);
	
	// creer le controleur et l'affecter au modele
	Control3D cobj = new Control3D ();
	add (cobj);
	cobj.setListener (obj);
	
	// creer un second modele qui represente le repre de la scne
	Model3D axis = new Model3D (getDocumentBase(), "applet/axis.obj");
	view.addModel (axis);
	
	// calculer la vue pour que tous les objets soient visibles
	view.setView ();
	
	// crer un bouton qui sert  recentrer la vue
	resetView = new Button ("Reset view");
	add (resetView);
    }
    
    /** Mthode appele par le bouton "Reset view" */
    public boolean action (Event e, Object arg) {
    	if (e.target == resetView) {
    		// recentrer la vue
    		view.setView ();
    		return true;
    	}
    	return false;
    }
}
