CREATE TABLE artists (
  id SERIAL NOT NULL,
  name VARCHAR(50) NOT NULL,
  birth_date DATE NOT NULL,
  death_date DATE NOT NULL,
  nationality VARCHAR(50) NOT NULL,
  PRIMARY KEY (id)
);

CREATE TABLE artworks (
  id SERIAL NOT NULL,
  title VARCHAR(100) NOT NULL,
  artist_id int NOT NULL,
  year_created int NOT NULL,
  medium VARCHAR(50) NOT NULL,
  dimensions VARCHAR(50) NOT NULL,
  image_url VARCHAR(255) NOT NULL,
  PRIMARY KEY (id),
  FOREIGN KEY (artist_id) REFERENCES artists(id)
);

CREATE TABLE museums (
  id SERIAL NOT NULL,
  name VARCHAR(100) NOT NULL,
  location VARCHAR(100) NOT NULL,
  PRIMARY KEY (id)
);

CREATE TABLE artwork_museums (
  artwork_id int NOT NULL,
  museum_id int NOT NULL,
  PRIMARY KEY (artwork_id, museum_id),
  FOREIGN KEY (artwork_id) REFERENCES artworks(id),
  FOREIGN KEY (museum_id) REFERENCES museums(id)
);



INSERT INTO artists (name, birth_date, death_date, nationality)
VALUES
  ('Vincent van Gogh', '1853-03-30', '1890-07-29', 'Dutch'),
  ('Pablo Picasso', '1881-10-25', '1973-04-08', 'Spanish'),
  ('Leonardo da Vinci', '1452-04-15', '1519-05-02', 'Italian'),
  ('Claude Monet', '1840-11-14', '1926-12-05', 'French'),
  ('Edvard Munch', '1863-12-12', '1944-01-23', 'Norwegian'),
  ('Salvador Dalí', '1904-05-11', '1989-01-23', 'Spanish'),
  ('Rembrandt van Rijn', '1606-07-15', '1669-10-04', 'Dutch'),
  ('Michelangelo', '1475-03-06', '1564-02-18', 'Italian'),
  ('Raphael', '1483-04-06', '1520-04-06', 'Italian'),
  ('Vincent Willem van Gogh', '1853-03-30', '1890-07-29', 'Dutch'),
  ('William Turner', '1775-04-23', '1851-12-19', 'English'),
  ('Salvador Felipe Jacinto Dalí i Domènech', '1904-05-11', '1989-01-23', 'Spanish'),
  ('Jackson Pollock', '1912-01-28', '1956-08-11', 'American'),
  ('Frida Kahlo', '1907-07-06', '1954-07-13', 'Mexican'),
  ('Henri Matisse', '1869-12-31', '1954-11-03', 'French'),
  ('Piet Mondrian', '1872-03-07', '1944-02-01', 'Dutch'),
  ('Marc Chagall', '1887-07-06', '1985-03-28', 'Russian-French'),
  ('Georges Seurat', '1859-12-02', '1891-03-29', 'French'),
  ('Johannes Vermeer', '1632-10-31', '1675-12-15', 'Dutch'),
  ('Gustav Klimt', '1862-07-14', '1918-02-06', 'Austrian'),
  ('Wassily Kandinsky', '1866-12-16', '1944-12-13', 'Russian'),
  ('Paul Cézanne', '1839-01-19', '1906-10-22', 'French'),
  ('Auguste Rodin', '1840-11-12', '1917-11-17', 'French'),
  ('Caravaggio', '1571-09-29', '1610-07-18', 'Italian'),
  ('Jan van Eyck', '1390-01-01', '1441-01-01', 'Flemish'),
  ('Pieter Bruegel the Elder', '1525-01-01', '1569-09-09', 'Flemish'),
  ('Sandro Boticelli', '1445-03-01', '1510-05-17', 'Italian')
;

INSERT INTO artworks (title, artist_id, year_created, medium, dimensions, image_url)
VALUES
  ('Starry Night', 1, 1889, 'Oil on canvas', '73.7 cm × 92.1 cm', 'https://upload.wikimedia.org/wikipedia/commons/thumb/e/ea/Van_Gogh_-_Starry_Night_-_Google_Art_Project.jpg/480px-Van_Gogh_-_Starry_Night_-_Google_Art_Project.jpg'),
  ('Guernica', 2, 1937, 'Oil on canvas', '3.49 m × 7.76 m', 'https://upload.wikimedia.org/wikipedia/en/7/74/PicassoGuernica.jpg'),
  ('Mona Lisa', 3, 1503, 'Oil on poplar', '77 cm × 53 cm', 'https://upload.wikimedia.org/wikipedia/commons/thumb/6/6a/Mona_Lisa.jpg/402px-Mona_Lisa.jpg'),
  ('Spring by the Seine', 4, 1875, 'Oil on canvas', '61 cm × 50.5 cm', 'https://upload.wikimedia.org/wikipedia/commons/c/cf/Claude_Monet_-_Spring_by_the_Seine_-_Google_Art_Project.jpg'),
  ('The Scream', 5, 1893, 'Oil, tempera, pastel and crayon on cardboard', '91 cm × 73.5 cm', 'https://upload.wikimedia.org/wikipedia/commons/thumb/f/f4/The_Scream.jpg/800px-The_Scream.jpg'),
  ('The Persistence of Memory', 6, 1931, 'Oil on canvas', '24 cm × 33 cm', 'https://upload.wikimedia.org/wikipedia/en/thumb/c/c4/The_Persistence_of_Memory.jpg/600px-The_Persistence_of_Memory.jpg'),
  ('The Night Watch', 7, 1642, 'Oil on canvas', '363 cm × 437 cm', 'https://upload.wikimedia.org/wikipedia/commons/thumb/4/4b/Nachtwacht_Rijksmuseum_SK-A-3063.jpeg/640px-Nachtwacht_Rijksmuseum_SK-A-3063.jpeg'),
  ('The Creation of Adam', 8, 1512, 'Fresco', '280 cm × 570 cm', 'https://en.wikipedia.org/wiki/File:Michelangelo_-_Creation_of_Adam_(cropped).jpg'),
  ('Les Demoiselles d''Avignon', 2, 1907, 'Oil on canvas', '243.9 cm × 233.7 cm', 'https://upload.wikimedia.org/wikipedia/en/thumb/4/4c/Les_Demoiselles_d%27Avignon.jpg/640px-Les_Demoiselles_d%27Avignon.jpg'),
  ('The Birth of Venus', 27, 1485, 'Tempera on canvas', '172.5 cm × 278.5 cm', 'https://upload.wikimedia.org/wikipedia/commons/thumb/a/af/The_Birth_of_Venus_by_Sandro_Botticelli.jpg/640px-The_Birth_of_Venus_by_Sandro_Botticelli.jpg'),
  ('Giuditta e Oloferne', 24, 1588, 'Oil on canvas', '145 cm × 195 cm', 'https://en.wikipedia.org/wiki/File:Judith_Beheading_Holofernes-Caravaggio_(c.1598-9).jpg'),
  ('Narcissus', 24, 1597, 'Oil on canvas', '110 cm × 92 cm', 'https://en.wikipedia.org/wiki/File:Narcissus-Caravaggio_(1594-96)_edited.jpg'),
  ('John the Baptist', 24, 1604, 'Oil on canvas', '94 cm × 131 cm', 'https://en.wikipedia.org/wiki/File:Michelangelo_Merisi_da_Caravaggio_-_St_John_the_Baptist_-_WGA04154.jpg'),
  ('Woman with Scarf', 20, 1910, 'Colored pencil on paper', '56.2 cm x 37.1 cm', 'https://www.moma.org/collection/works/33171'),
  ('Doni Madonna', 8, 1507, 'Tempera grassa on wood', '120 cm diameter', 'https://en.wikipedia.org/wiki/File:Tondo_Doni,_por_Miguel_%C3%81ngel.jpg'),
  ('The Beautiful Gardener', 9, 1505, 'Oil on Canvas', '122 cm x 80 cm', 'https://commons.wikimedia.org/wiki/File:La-belle-jardiniere.jpg?uselang=fr'),
  ('The Holy Family of Francis I', 9, 1518, 'Oil on Canvas', '207 cm x 140 cm', 'https://en.wikipedia.org/wiki/File:La_Sainte_Famille_-_Rapha%C3%ABl_-_Mus%C3%A9e_du_Louvre_Peintures_INV_604.jpg'),
  ('The Beggars', 26, 1568, 'Oil on Canvas', '18.5 cm × 21.5 cm', 'https://en.wikipedia.org/wiki/File:Les_Mendiants_-_Pieter_Brueghel_l%27Ancien_-_Mus%C3%A9e_du_Louvre_Peintures_RF_730.jpg'),
  ('The Adoration of the Kings', 26, 1564, 'Oil on Panel', '112.1 cm × 83.9 cm', 'https://en.wikipedia.org/wiki/File:Anbetung_der_K%C3%B6nige_(Bruegel,_1564)_%E2%80%93_cropped.jpg'),
  ('The Milkmaid', 19, 1657, 'Oil on Canvas', '45.5 cm x 41 cm', 'https://en.wikipedia.org/wiki/File:Johannes_Vermeer_-_Het_melkmeisje_-_Google_Art_Project.jpg'),
  ('Woman Reading a Letter', 19, 1662, 'Oil on Canvas', '46.6 cm × 39.1 cm', 'https://en.wikipedia.org/wiki/File:Vermeer,_Johannes_-_Woman_reading_a_letter_-_ca._1662-1663.jpg'),
  ('The Stone Bridge', 7, 1637, 'Oil on panel', '29 cm x 42 cm', 'https://en.wikipedia.org/wiki/File:Rembrandt_Harmensz._van_Rijn_-_De_stenen_brug_-_Google_Art_Project.jpg'),
  ('The Water-Lily Pond', 4, 1899, 'Oil on canvas', '88.3 cm × 93.1 cm', 'https://en.wikipedia.org/wiki/File:Claude_Monet,_The_Water-Lily_Pond_(National_Gallery,_London).jpg'),
  ('Lady Seated at a Virginal', 19, 1670, 'Oil on canvas', '51.5 cm × 45.5 cm', 'https://en.wikipedia.org/wiki/File:Lady_Seated_at_a_Virginal,_Vermeer,_The_National_Gallery,_London.jpg'),
  ('The Manchester Madonna',8, 1604, 'Tempera on panel', '105 cm × 76 cm', 'https://en.wikipedia.org/wiki/File:MICHELANGELO_-_Manchester_Madonna_adjusted.JPG'),
  ('The Evening Star', 11, 1830, 'Oil on canvas', '91.1 cm x 122.6 cm', 'https://commons.wikimedia.org/wiki/File:Evening_Star_1983.jpg')
  ;

INSERT INTO museums (name, location)
VALUES
  ('Louvre', 'Paris, France'),
  ('Museum of Modern Art', 'New York, USA'),
  ('Rijksmuseum', 'Amsterdam, Netherlands'),
  ('Galleria Nazionale d''Arte Antica', 'Rome, Italy'),
  ('National Gallery', 'Oslo, Norway'),
  ('Sistine Chapel', 'Vatican city, Vatican'),
  ('Uffizi Gallery', 'Florence, Italy'),
  ('National Gallery', 'London, UK')
  ;

INSERT INTO artwork_museums (artwork_id, museum_id)
VALUES
  (1, 1),
  (2, 2),
  (3, 1),
  (4, 5),
  (5, 5),
  (6, 2),
  (7, 3),
  (8, 6),
  (9, 2),
  (10, 7),
  (11, 4),
  (12, 4),
  (13, 4),
  (14, 2),
  (15, 7),
  (16, 1),
  (17, 1),
  (18, 8),
  (19, 3),
  (20, 3),
  (21, 3),
  (22, 3),
  (23, 8),
  (24, 8),
  (25, 8),
  (26, 8)
  ;
