/*
 * Decompiled with CFR 0.152.
 */
import Mecanique.Case;
import Mecanique.CaseIntraversable;
import Mecanique.CaseLibre;
import Mecanique.CaseTraversable;
import Mecanique.Direction;
import Mecanique.Entite;
import Mecanique.Joueur;
import Mecanique.Mobile;
import Mecanique.Monstre;
import Mecanique.Obstacle;
import Mecanique.Personnage;
import Mecanique.Sortie;
import Mecanique.Terrain;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FenetreJeu
extends JPanel
implements KeyListener {
    private Terrain terrain;
    private int tailleCase = 24;
    private int hauteur;
    private int largeur;
    private JFrame frame;
    private Joueur joueur;

    public FenetreJeu(Terrain t) {
        JFrame frame;
        this.hauteur = t.getHauteur();
        this.largeur = t.getLargeur();
        this.terrain = t;
        this.joueur = t.getJoueur();
        this.setBackground(Color.GRAY);
        this.setPreferredSize(new Dimension(this.largeur * this.tailleCase, this.hauteur * this.tailleCase));
        this.frame = frame = new JFrame("Donjon");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(this);
        frame.pack();
        frame.setVisible(true);
        frame.addKeyListener(this);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        for (int l = 0; l < this.hauteur; ++l) {
            for (int c = 0; c < this.largeur; ++c) {
                this.paintCase(g, l, c);
            }
        }
    }

    public static Color getColor(Case c) {
        if (c instanceof CaseIntraversable) {
            return Color.BLACK;
        }
        if (c instanceof CaseLibre) {
            return Color.WHITE;
        }
        if (c instanceof Sortie) {
            return Color.BLUE;
        }
        return null;
    }

    public static Color getColor(Entite e) {
        if (e == null) {
            return Color.WHITE;
        }
        if (e instanceof Obstacle) {
            int shade = (5 - ((Obstacle)e).getResistance()) * 50;
            return new Color(shade, shade, shade);
        }
        if (e instanceof Personnage) {
            return Color.GREEN;
        }
        if (e instanceof Monstre) {
            return Color.RED;
        }
        if (e instanceof Joueur) {
            return Color.PINK;
        }
        return null;
    }

    public void paintCase(Graphics g, int lig, int col) {
        Case c = this.terrain.getCase(lig, col);
        g.setColor(FenetreJeu.getColor(c));
        g.fillRect(col * this.tailleCase, lig * this.tailleCase, this.tailleCase, this.tailleCase);
        if (c instanceof CaseTraversable) {
            Entite e = ((CaseTraversable)c).getContenu();
            g.setColor(FenetreJeu.getColor(e));
            g.fillOval(col * this.tailleCase, lig * this.tailleCase, this.tailleCase, this.tailleCase);
            if (e instanceof Mobile) {
                this.paintDirection(g, lig, col, ((Mobile)e).getDir());
            }
        }
    }

    public void paintDirection(Graphics g, int lig, int col, Direction dir) {
        int dt = this.tailleCase / 3;
        int x = col * this.tailleCase + dt;
        int y = lig * this.tailleCase + dt;
        int dx = 0;
        int dy = 0;
        switch (dir) {
            case nord: {
                dy = -dt;
                break;
            }
            case sud: {
                dy = dt;
                break;
            }
            case est: {
                dx = dt;
                break;
            }
            case ouest: {
                dx = -dt;
            }
        }
        g.setColor(Color.BLACK);
        g.fillOval(x + dx, y + dy, dt, dt);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 38: {
                this.joueur.bouge(this.terrain.cible(this.joueur.getCase(), Direction.nord));
                break;
            }
            case 40: {
                this.joueur.bouge(this.terrain.cible(this.joueur.getCase(), Direction.sud));
                break;
            }
            case 37: {
                this.joueur.bouge(this.terrain.cible(this.joueur.getCase(), Direction.ouest));
                break;
            }
            case 39: {
                this.joueur.bouge(this.terrain.cible(this.joueur.getCase(), Direction.est));
                break;
            }
            case 32: {
                Case c = this.joueur.getCase();
                if (!(c instanceof Sortie)) break;
                c.vide();
            }
        }
    }

    public void ecranFinal(int n) {
        this.frame.remove(this);
        JLabel label = new JLabel("Score " + n);
        label.setFont(new Font("Verdana", 1, 20));
        label.setHorizontalAlignment(0);
        label.setSize(this.getSize());
        this.frame.getContentPane().add(label);
        this.frame.repaint();
    }
}

