/*
 * Decompiled with CFR 0.152.
 */
package Mecanique;

import Mecanique.Case;
import Mecanique.CaseIntraversable;
import Mecanique.CaseLibre;
import Mecanique.CaseTraversable;
import Mecanique.Direction;
import Mecanique.Joueur;
import Mecanique.Monstre;
import Mecanique.Obstacle;
import Mecanique.Personnage;
import Mecanique.Sortie;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Scanner;

public class Terrain {
    private int hauteur;
    private int largeur;
    private Case[][] carte;
    private Joueur joueur;

    public Joueur getJoueur() {
        return this.joueur;
    }

    public Terrain(String file) {
        try {
            Scanner sc = new Scanner(new FileInputStream(file));
            this.hauteur = sc.nextInt();
            this.largeur = sc.nextInt();
            sc.nextLine();
            int resistanceJoueur = sc.nextInt();
            sc.nextLine();
            this.carte = new Case[this.hauteur][this.largeur];
            for (int l = 0; l < this.hauteur; ++l) {
                String line = sc.nextLine();
                for (int c = 0; c < this.largeur; ++c) {
                    Case cc;
                    Character ch = Character.valueOf(line.charAt(c));
                    switch (ch.charValue()) {
                        case '#': {
                            cc = new CaseIntraversable(l, c);
                            break;
                        }
                        case ' ': {
                            cc = new CaseLibre(l, c);
                            break;
                        }
                        case 'o': {
                            cc = new Sortie(l, c);
                            break;
                        }
                        case '@': {
                            cc = new CaseLibre(l, c, new Obstacle());
                            break;
                        }
                        case 'H': {
                            if (this.joueur != null) {
                                throw new IllegalArgumentException("carte avec deux joueurs");
                            }
                            cc = new CaseLibre(l, c);
                            this.joueur = new Joueur(cc, resistanceJoueur);
                            cc.entre(this.joueur);
                            break;
                        }
                        case '<': 
                        case '>': 
                        case '^': 
                        case 'v': {
                            cc = new CaseLibre(l, c, new Personnage(Direction.ofChar(ch)));
                            break;
                        }
                        case 'm': 
                        case 'w': 
                        case '\u00ab': 
                        case '\u00bb': {
                            cc = new CaseLibre(l, c, new Monstre(Direction.ofChar(ch)));
                            break;
                        }
                        default: {
                            cc = null;
                        }
                    }
                    this.carte[l][c] = cc;
                }
            }
            sc.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public int getHauteur() {
        return this.hauteur;
    }

    public int getLargeur() {
        return this.largeur;
    }

    public Case getCase(int l, int c) {
        return this.carte[l][c];
    }

    public Case cible(Case c, Direction d) {
        switch (d) {
            case nord: {
                return this.getCase(c.lig - 1, c.col);
            }
            case sud: {
                return this.getCase(c.lig + 1, c.col);
            }
            case est: {
                return this.getCase(c.lig, c.col + 1);
            }
            case ouest: {
                return this.getCase(c.lig, c.col - 1);
            }
        }
        return null;
    }

    public ArrayList<CaseTraversable> traversables() {
        ArrayList<CaseTraversable> arr = new ArrayList<CaseTraversable>();
        Case[][] caseArray = this.carte;
        int n = caseArray.length;
        for (int i = 0; i < n; ++i) {
            Case[] ligne;
            for (Case c : ligne = caseArray[i]) {
                if (!(c instanceof CaseTraversable)) continue;
                arr.add((CaseTraversable)c);
            }
        }
        return arr;
    }

    public int comptePersonnages() {
        int n = 0;
        Case[][] caseArray = this.carte;
        int n2 = caseArray.length;
        for (int i = 0; i < n2; ++i) {
            Case[] ligne;
            for (Case c : ligne = caseArray[i]) {
                if (!(c instanceof CaseTraversable) || !(((CaseTraversable)c).getContenu() instanceof Personnage)) continue;
                ++n;
            }
        }
        return n;
    }

    public boolean joueurAbsent() {
        Case[][] caseArray = this.carte;
        int n = caseArray.length;
        for (int i = 0; i < n; ++i) {
            Case[] ligne;
            for (Case c : ligne = caseArray[i]) {
                if (!(c instanceof CaseTraversable) || !(((CaseTraversable)c).getContenu() instanceof Joueur)) continue;
                return false;
            }
        }
        return true;
    }

    public void print() {
        Case[][] caseArray = this.carte;
        int n = caseArray.length;
        for (int i = 0; i < n; ++i) {
            Case[] ligne;
            for (Case c : ligne = caseArray[i]) {
                System.out.print(c);
            }
            System.out.println();
        }
        System.out.println();
    }
}

