package gestionCours;

import java.util.ArrayList;
import java.util.HashMap;

public class Cours {
    //attributs
    private String nom;
    private String nomResponable;
    private int etudiantsMax;
    private ArrayList<Etudiant> etudiants;
    //notes par etudiants
    private HashMap<Etudiant, ArrayList<Note>> notes;
    //coef repatition de la note en pourcentage de la note de la matiere
    private ArrayList<Integer> coef;



    //constructeurs

    public Cours(String nom, String nomResponable, int etudiantsMax) {
        this.nom = nom;
        this.nomResponable = nomResponable;
        this.etudiantsMax = etudiantsMax;
        this.etudiants = new ArrayList<>();
        this.notes = new HashMap<Etudiant, ArrayList<Note>>();
        this.coef = new ArrayList<>();
        //par défaut : 100% sur une seule note
        this.coef.add(100);
    }

    public Cours(String nom, String nomResponable){
        this(nom, nomResponable, 20);
    }


    //methodes

    /**
     * Coefficiente les notes pour ce cours
     * @param coefficients sous forme de liste de pourcentage, par ordre chronologique des notes attribuees
     */
    public void setCoef(ArrayList<Integer> coefficients){
        this.coef = (ArrayList<Integer>) coefficients.clone();

    }


    /**
     *
     * @param e
     * @return vrai si l'etudiant a pu etre ajoute
     */
    public boolean ajouterEtudiant(Etudiant e){
        //si le cours est plain
        if (etudiants.size() >= etudiantsMax){
            return false;
        }

        this.etudiants.add(e);
        //Initialiser son tableau de notes !
        ArrayList<Note> noteEtu = new ArrayList<>();
        notes.put(e, noteEtu);
        return true;
    }

    public void donneNote(Etudiant e, Note n){
        ArrayList<Note> noteEtu = this.notes.get(e);
        noteEtu.add(n);
    }

    public boolean valide(Etudiant e){
        Note moyenne = calculeMoyenne(e);
        return moyenne.isAverage();
    }

    public Note calculeMoyenne(Etudiant e){
        return Note.computeAverage(this.notes.get(e), coef);

    }

}
