# 4 "code_lexer.mll"
 
  open Printf
  open Lexing
  open Instr
  open Code_parser

  let string_buffer = Buffer.create 512

  exception LexicalError of int

  let keyword_list = [
    "add", INSTR Add; 
    "sub", INSTR Sub;
    "mul", INSTR Mul;
    "div", INSTR Div;
    "mod", INSTR Mod;
    "not", INSTR Not;
    "inf", INSTR Inf;
    "infeq", INSTR Infeq;
    "sup", INSTR Sup;
    "supeq", INSTR Supeq;
    "fadd", INSTR Fadd;
    "fsub", INSTR Fsub;
    "fmul", INSTR Fmul;
    "fdiv", INSTR Fdiv;
    "fcos", INSTR Fcos;
    "fsin", INSTR Fsin;
    "finf", INSTR Finf;
    "finfeq", INSTR Finfeq;
    "fsup", INSTR Fsup;
    "fsupeq", INSTR Fsupeq;
    "padd", INSTR Padd;
    "concat", INSTR Concat;
    "equal", INSTR Equal;
    "isaddr", INSTR Is_addr;
    "atoi", INSTR Atoi;
    "atof", INSTR Atof;
    "itof", INSTR Itof;
    "ftoi", INSTR Ftoi;
    "stri", INSTR Stri;
    "strf", INSTR Strf;
    "pushsp", INSTR Pushsp;
    "pushfp", INSTR Pushfp;
    "pushgp", INSTR Pushgp;
    "loadn", INSTR Loadn;
    "storen", INSTR Storen ; 
    "swap", INSTR Swap;
    "writei", INSTR Writei;
    "writef", INSTR Writef;
    "writes", INSTR Writes;
    "read", INSTR Read;
    "drawline", INSTR DrawLine;
    "drawpoint", INSTR DrawPoint;
    "drawcircle", INSTR DrawCircle;
    "drawrect", INSTR DrawRect;
    "fillrect", INSTR FillRect;
    "setcolor", INSTR SetColor;
    "cleardrawingarea", INSTR ClearDrawingArea;
    "opendrawingarea", INSTR OpenDrawingArea;
    "refresh", INSTR Refresh;
    "call", INSTR Call;
    "return", INSTR Return;
    "start", INSTR Start;
    "nop", INSTR Nop;
    "stop", INSTR Stop; 
    "allocn", INSTR Allocn;
    "free", INSTR Free;
    "dupn", INSTR Dupn;
    "popn", INSTR Popn;
    (* instructions avec arguments *)
    "pushi", PUSHI;
    "pushn", PUSHN;
    "pushf", PUSHF;
    "pushs", PUSHS;
    "pushg", PUSHG;
    "pushl", PUSHL;
    "load", LOAD;
    "dup", DUP;
    "pop", POP;
    "storel", STOREL;
    "storeg", STOREG;
    "store", STORE;
    "check", CHECK;
    "label", LABEL;
    "jump", JUMP;
    "jz", JZ;
    "pusha", PUSHA;
    "err", ERR;
    "alloc", ALLOC ]

  let keyword =
    let t = Hashtbl.create 73 in
    List.iter (fun (name,kwd) -> Hashtbl.add t name kwd) keyword_list;
    fun s -> 
      let ls = String.lowercase s in
      try Hashtbl.find t ls with Not_found -> IDENT s


# 101 "code_lexer.ml"
let __ocaml_lex_tables = {
  Lexing.lex_base = 
   "\000\000\247\255\246\255\005\000\012\000\084\000\252\255\251\255\
    \159\000\171\000\248\255\181\000\209\000\235\000\245\000\011\000\
    \234\000\255\255\235\000\212\000\249\255\254\255\253\255";
  Lexing.lex_backtrk = 
   "\255\255\255\255\255\255\000\000\009\000\002\000\255\255\255\255\
    \009\000\005\000\255\255\006\000\255\255\255\255\006\000\001\000\
    \255\255\255\255\004\000\005\000\255\255\255\255\255\255";
  Lexing.lex_default = 
   "\002\000\000\000\000\000\255\255\255\255\255\255\000\000\000\000\
    \255\255\255\255\000\000\255\255\255\255\255\255\255\255\015\000\
    \018\000\000\000\018\000\255\255\000\000\000\000\000\000";
  Lexing.lex_trans = 
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\003\000\003\000\000\000\000\000\003\000\003\000\003\000\
    \000\000\000\000\003\000\000\000\000\000\255\255\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \003\000\000\000\010\000\000\000\000\000\003\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\007\000\008\000\000\000\004\000\
    \009\000\009\000\009\000\009\000\009\000\009\000\009\000\009\000\
    \009\000\009\000\006\000\015\000\000\000\000\000\000\000\000\000\
    \000\000\005\000\005\000\005\000\005\000\005\000\005\000\005\000\
    \005\000\005\000\005\000\005\000\005\000\005\000\005\000\005\000\
    \005\000\005\000\005\000\005\000\005\000\005\000\005\000\005\000\
    \005\000\005\000\005\000\000\000\000\000\000\000\000\000\005\000\
    \000\000\005\000\005\000\005\000\005\000\005\000\005\000\005\000\
    \005\000\005\000\005\000\005\000\005\000\005\000\005\000\005\000\
    \005\000\005\000\005\000\005\000\005\000\005\000\005\000\005\000\
    \005\000\005\000\005\000\005\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\005\000\005\000\005\000\005\000\
    \005\000\005\000\005\000\005\000\005\000\005\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\005\000\005\000\005\000\
    \005\000\005\000\005\000\005\000\005\000\005\000\005\000\005\000\
    \005\000\005\000\005\000\005\000\005\000\005\000\005\000\005\000\
    \005\000\005\000\005\000\005\000\005\000\005\000\005\000\000\000\
    \000\000\000\000\000\000\005\000\000\000\005\000\005\000\005\000\
    \005\000\005\000\005\000\005\000\005\000\005\000\005\000\005\000\
    \005\000\005\000\005\000\005\000\005\000\005\000\005\000\005\000\
    \005\000\005\000\005\000\005\000\005\000\005\000\005\000\009\000\
    \009\000\009\000\009\000\009\000\009\000\009\000\009\000\009\000\
    \009\000\011\000\000\000\009\000\009\000\009\000\009\000\009\000\
    \009\000\009\000\009\000\009\000\009\000\011\000\011\000\011\000\
    \011\000\011\000\011\000\011\000\011\000\011\000\011\000\000\000\
    \012\000\000\000\000\000\000\000\020\000\255\255\006\000\000\000\
    \000\000\000\000\012\000\000\000\013\000\000\000\013\000\000\000\
    \001\000\014\000\014\000\014\000\014\000\014\000\014\000\014\000\
    \014\000\014\000\014\000\255\255\017\000\255\255\000\000\000\000\
    \012\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\012\000\014\000\014\000\014\000\014\000\014\000\
    \014\000\014\000\014\000\014\000\014\000\014\000\014\000\014\000\
    \014\000\014\000\014\000\014\000\014\000\014\000\014\000\000\000\
    \022\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\021\000\000\000\000\000\000\000\019\000\255\255\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\020\000\255\255\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000";
  Lexing.lex_check = 
   "\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\000\000\000\000\255\255\255\255\000\000\003\000\003\000\
    \255\255\255\255\003\000\255\255\255\255\015\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \000\000\255\255\000\000\255\255\255\255\003\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\000\000\000\000\255\255\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\004\000\255\255\255\255\255\255\255\255\
    \255\255\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\255\255\255\255\255\255\255\255\000\000\
    \255\255\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\005\000\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\005\000\005\000\005\000\005\000\
    \005\000\005\000\005\000\005\000\005\000\005\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\005\000\005\000\005\000\
    \005\000\005\000\005\000\005\000\005\000\005\000\005\000\005\000\
    \005\000\005\000\005\000\005\000\005\000\005\000\005\000\005\000\
    \005\000\005\000\005\000\005\000\005\000\005\000\005\000\255\255\
    \255\255\255\255\255\255\005\000\255\255\005\000\005\000\005\000\
    \005\000\005\000\005\000\005\000\005\000\005\000\005\000\005\000\
    \005\000\005\000\005\000\005\000\005\000\005\000\005\000\005\000\
    \005\000\005\000\005\000\005\000\005\000\005\000\005\000\008\000\
    \008\000\008\000\008\000\008\000\008\000\008\000\008\000\008\000\
    \008\000\009\000\255\255\009\000\009\000\009\000\009\000\009\000\
    \009\000\009\000\009\000\009\000\009\000\011\000\011\000\011\000\
    \011\000\011\000\011\000\011\000\011\000\011\000\011\000\255\255\
    \009\000\255\255\255\255\255\255\016\000\018\000\019\000\255\255\
    \255\255\255\255\011\000\255\255\012\000\255\255\012\000\255\255\
    \000\000\012\000\012\000\012\000\012\000\012\000\012\000\012\000\
    \012\000\012\000\012\000\015\000\016\000\018\000\255\255\255\255\
    \009\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\011\000\013\000\013\000\013\000\013\000\013\000\
    \013\000\013\000\013\000\013\000\013\000\014\000\014\000\014\000\
    \014\000\014\000\014\000\014\000\014\000\014\000\014\000\255\255\
    \019\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\019\000\255\255\255\255\255\255\016\000\018\000\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\016\000\018\000\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255";
  Lexing.lex_base_code = 
   "";
  Lexing.lex_backtrk_code = 
   "";
  Lexing.lex_default_code = 
   "";
  Lexing.lex_trans_code = 
   "";
  Lexing.lex_check_code = 
   "";
  Lexing.lex_code = 
   "";
}

let rec token lexbuf =
    __ocaml_lex_token_rec lexbuf 0
and __ocaml_lex_token_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 112 "code_lexer.mll"
            ( token lexbuf )
# 264 "code_lexer.ml"

  | 1 ->

  let c = Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_start_pos + 2) lexbuf.Lexing.lex_curr_pos in
# 113 "code_lexer.mll"
                        ( COMMENT c )
# 271 "code_lexer.ml"

  | 2 ->
# 114 "code_lexer.mll"
                        ( let s = lexeme lexbuf in keyword s )
# 276 "code_lexer.ml"

  | 3 ->
# 115 "code_lexer.mll"
                        ( COLON )
# 281 "code_lexer.ml"

  | 4 ->
# 116 "code_lexer.mll"
                        ( COMMA )
# 286 "code_lexer.ml"

  | 5 ->
# 117 "code_lexer.mll"
                       ( INT (int_of_string (lexeme lexbuf)) )
# 291 "code_lexer.ml"

  | 6 ->
# 118 "code_lexer.mll"
                        ( FLOAT (float_of_string (lexeme lexbuf)) )
# 296 "code_lexer.ml"

  | 7 ->
# 120 "code_lexer.mll"
      ( Buffer.clear string_buffer;
	string lexbuf;
	STRING (Buffer.contents string_buffer) )
# 303 "code_lexer.ml"

  | 8 ->
# 123 "code_lexer.mll"
          ( EOF )
# 308 "code_lexer.ml"

  | 9 ->
# 124 "code_lexer.mll"
      ( raise (LexicalError (lexeme_start lexbuf)) )
# 313 "code_lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; __ocaml_lex_token_rec lexbuf __ocaml_lex_state

and string lexbuf =
    __ocaml_lex_string_rec lexbuf 16
and __ocaml_lex_string_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 131 "code_lexer.mll"
      ( lexeme_end lexbuf )
# 324 "code_lexer.ml"

  | 1 ->
# 133 "code_lexer.mll"
      ( Buffer.add_char string_buffer '\n';
	string lexbuf )
# 330 "code_lexer.ml"

  | 2 ->
# 136 "code_lexer.mll"
      ( Buffer.add_char string_buffer '\\';
	string lexbuf )
# 336 "code_lexer.ml"

  | 3 ->
# 139 "code_lexer.mll"
      ( Buffer.add_char string_buffer '"';
	string lexbuf )
# 342 "code_lexer.ml"

  | 4 ->
# 142 "code_lexer.mll"
      ( Buffer.add_string string_buffer (lexeme lexbuf);
	string lexbuf )
# 348 "code_lexer.ml"

  | 5 ->
# 145 "code_lexer.mll"
      ( raise (LexicalError (lexeme_start lexbuf)) )
# 353 "code_lexer.ml"

  | 6 ->
# 147 "code_lexer.mll"
      ( raise (LexicalError (lexeme_start lexbuf)) )
# 358 "code_lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; __ocaml_lex_string_rec lexbuf __ocaml_lex_state

;;

# 150 "code_lexer.mll"
 


# 368 "code_lexer.ml"
