
(* Instructions pour la machine virtuelle *)

type t = 
  (* oprations sur les entiers *)
  | Add
  | Sub
  | Mul
  | Div
  | Mod
  | Not
  | Inf
  | Infeq
  | Sup
  | Supeq
  (* oprations sur les rels *)
  | Fadd
  | Fsub
  | Fmul
  | Fdiv
  | Fcos
  | Fsin
  | Finf
  | Finfeq
  | Fsup
  | Fsupeq
  (* oprations sur les adresses *)
  | Padd
  (* opration sur les chanes *)
  | Concat
  (* oprations sur le tas *)
  | Alloc of int
  | Allocn 
  | Free
  (* galit *)
  | Equal
  | Is_addr
  (* conversions *)
  | Atoi
  | Atof
  | Itof
  | Ftoi
  | Stri
  | Strf
  (* empiler *)
  | Pushi of int
  | Pushn of int
  | Pushf of float
  | Pushs of Hstring.t
  | Pushg of int
  | Pushl of int
  | Pushsp
  | Pushfp
  | Pushgp
  | Load of int
  | Loadn
  | Dup of int
  | Dupn
  (* dpiler *)
  | Pop of int
  | Popn
  (* Stocker *)
  | Storel of int
  | Storeg of int
  | Store of int 
  | Storen 
  (* divers *)
  | Check of int * int
  | Swap
  (* entres-sorties *)
  | Writei
  | Writef
  | Writes
  | Read
  (* primitives graphiques *)
  | DrawLine
  | DrawPoint
  | DrawCircle
  | DrawRect
  | FillRect
  | SetColor
  | OpenDrawingArea
  | ClearDrawingArea 
  | Refresh
  (* sauts *)
  | Label of Label.t
  | Jump of Label.t
  | Jz of Label.t
  | Pusha of Label.t
  (* procdures *)
  | Call
  | Return
  (* initialisation *)
  | Start
  | Nop
  | Err of string
  | Stop

