#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "file_manip.h"

#define BUFFER_SIZE 20

/* Gestion des erreurs dans les arguments */
void arguments_error(char* message)
{
  fprintf(stderr,"Erreur %s.\n", message);
  fprintf(stderr,"Usage: mon_cp source destination\n");
  exit(1);
}


/* Fonction utile à partir de l'exercice 4 pour déterminer le nom du
   fichier destination */
char * create_copy_name(char* source, char* destination)
{
  char * basename = strrchr(source,'/');
  if ( NULL == basename ) {
    basename = source;
  }
  char * dirname = destination;
  char * filename =
    (char*) malloc(sizeof(char) * (strlen(basename) + 1 + strlen(dirname) + 1));
  if ( NULL == filename ) {
    return NULL;
  }
  *filename='\0';
  strcat(filename,dirname);
  strcat(filename,"/");
  strcat(filename,basename);
  return filename;
}

/* Copie de fichier */
/* Version de l'exercide 1 sans detection des erreurs */
int copy(char* source, char* destination)
{
  printf("Copie du fichier %s sur le fichier %s\n",source,destination);

  // Ouverture des fichiers source et destination respectivement en
  // lecture et en écriture
  MY_FILE* src = my_fopen(source, "r");
  MY_FILE* dst = my_fopen(destination, "w");

  // Allocation de la mémoire tampon pour transférer des données du
  // fichier source sur le fichier destination
  char* buf = (char*) malloc(sizeof(char) * BUFFER_SIZE);

  int res = 0;
  int nb_data_read = 0;

  // On boucle tant qu'il y a quelque chose à lire.
  // On copie ensuite ce qui vient d'être lu dans le fichier destination.
  // On prend soin de ne copier que ce qui vient d'être lu :
  // (nb_data_read != BUFFER_SIZE) !
  while ( (nb_data_read = my_fread(buf, sizeof(char), BUFFER_SIZE, src)) ) {
    res = my_fwrite(buf, sizeof(char), nb_data_read, dst);
  }

  // On ferme les fichiers source et destination
  my_fclose(src);
  my_fclose(dst);

  // On libere la mémoire occupée par le buffer
  free(buf);

  return 0;
}


/* Programme principal */
int main(int argc, char* argv[])
{
  int error_code = 0;
  /* Gestion des paramètres */
  char * source;
  char * destination;
  switch(argc) {
    case 3:
      /* cas des exercices 1 à 3 */
      /* des modifications sont requises pour l'exercice 4 */
      source = argv[1];
      destination = argv[2];
      error_code = copy(source, destination);
      break;
    default:
      arguments_error("nombre d'arguments invalide");
    }
  return error_code;
}
