#include "file_manip.h"
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>

MY_FILE *my_fopen(const char *path, const char *mode)
{
  int flags = 0;
  mode_t permission = 0;

  // Ne gerez que les mode d'ouverture 'r' et 'w', les autres ne sont
  // pas utiles pour votre programme mon_cp
  switch (*mode)
    {
    case 'r':
      flags = O_RDONLY;
      break;
    case 'w':
      flags =  O_CREAT|O_WRONLY|O_TRUNC;
      permission = S_IRUSR | S_IWUSR | S_IRGRP | S_IROTH;
      break;
    default:
      errno = EINVAL;
      return NULL;
    }

  // Allocation de la mémoire pour notre structure
  MY_FILE* file_info = (MY_FILE*) malloc(sizeof(MY_FILE));
  if ( NULL == file_info ) {
    return NULL;
  }

  // Ouverture du fichier et récupération du descripteur
  file_info->fd = open(path,flags,permission);
  if ( -1 == file_info->fd ) {
    free(file_info);
    return NULL;
  }
  return file_info;
}

// This version of my_fread checks for read interruption
size_t my_fread(void *ptr, size_t size, size_t nmemb, MY_FILE *stream)
{
  int count = size * nmemb;
  int nb_data_read = 0;
  int nb_total_data_read = 0;
  while ( 0 != (nb_data_read = read(stream->fd, ptr, count)) ) {
    if ( -1 == nb_data_read ) {
      if ( EINTR == errno ) {
	continue;
      }
      else {
	return 0;
      }
    }
    nb_total_data_read += nb_data_read;
    ptr = (char*)ptr + nb_data_read;
    count -= nb_data_read;
  }
  return nb_total_data_read / size;
}


//This version of my_fwrite checks for write interruption
size_t my_fwrite(const void *ptr, size_t size, size_t nmemb, MY_FILE *stream)
{
  int count = size * nmemb;
  int nb_data_write = 0;
  int nb_total_data_write = 0;
  while ( 0 != (nb_data_write = write(stream->fd, ptr, count)) ) {
    if ( -1 == nb_data_write ) {
      if ( EINTR == errno ) {
	continue;
      }
      else
	return 0;
    }
    nb_total_data_write += nb_data_write;
    ptr = (char*)ptr + nb_data_write;
    count -= nb_data_write;
  }
  return nb_total_data_write / size;
}

int my_fclose(MY_FILE *fp)
{
  // On ferme le fichier
  int res = close (fp->fd);
  // On libere la mémoire
  free(fp);
  return  res;
}
