/* en-têtes standard */
#include <sys/types.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>

#include <sys/stat.h>
#include <sys/wait.h>   /* pour avoir wait & co. */
#include <ctype.h>      /* pour avoir isspace & co. */
#include <string.h>
#include <errno.h>      /* pour avoir errno */
#include <signal.h>
#include <fcntl.h>

char   ligne[4096];     /* contient la ligne d'entrée */

/* pointeurs sur les mots de ligne (voir decoupe) */
#define MAXELEMS 32
char* elems[MAXELEMS];


void affiche_invite()
{
  printf("--> ");
  fflush(stdout);
}

void lit_ligne()
{
  if (!fgets(ligne,sizeof(ligne)-1,stdin)) {
    printf("\n");
    exit(0);
  }
}

/* découpe ligne en mots
   fait pointer chaque elems[i] sur un mot différent
   elems se termine par NULL
 */
void decoupe(char *ligne, char** elems, int maxelems) {
  int i;
  char* debut = ligne;
  for (i=0; i<maxelems-1; i++) {
    /* saute les espaces */
    while (*debut && isspace(*debut)) debut++;
    /* fin de ligne ? */
    if (!*debut) break;
    /* on se souvient du début de ce mot */
    elems[i] = debut;
    /* cherche la fin du mot */
    while (*debut && !isspace(*debut)) debut++; /* saute le mot */
    /* termine le mot par un \0 et passe au suivant */
    if (*debut) { *debut = 0; debut++; }
  }
  elems[i] = NULL;
}

void execute(char **cmd_args) {
  int i;
  printf("execution de %s", cmd_args[0]);
  for(i=1; cmd_args[i] != NULL; i++) {
    printf (" %s", cmd_args[i]);
  }
  printf("\n");
  /* TODO */
}

int main()
{
  while (1) {
    affiche_invite();
    lit_ligne();
    decoupe(ligne, elems, MAXELEMS);
    execute(elems);
  }
  return 0;
}
