// -*- mode: c++; c-indent-level: 4; c++-member-init-indent: 8; comment-column: 35; -*-

//-----------------------------------------------------------------------------
// eoSigBinaryFlight.h
// (c) OPAC 2007
/*
    Contact: paradiseo-help@lists.gforge.inria.fr
 */
//-----------------------------------------------------------------------------

#ifndef EOSIGBINARYFLIGHT_H
#define EOSIGBINARYFLIGHT_H

//-----------------------------------------------------------------------------
#include <eoBinaryFlight.h>
//-----------------------------------------------------------------------------



/**
 * 	Binary flight based on the sigmoid function. Velocities are expected to be "double"
 *  Consider Pi to be the i-th position of a particle and Vi to be the i-th velocity of the same particle :
 * 		if rand[0;1] < sig(Vi) (Vi <=> double)
 * 			Pi=1
 * 	    else
 * 			Pi=0
 */
template < class POT > class eoSigBinaryFlight:public eoBinaryFlight < POT >
{

public:

    /**
     * Constructor.
     */
    eoSigBinaryFlight (){}


    /**
     * Sigmoid function
     */
    double sigmoid( double _value)
    {
        return(1/(1+ exp(- _value)));

    }

    /**
     * Apply the sigmoid binary flight to a particle.
     * 
     */
    void operator  () (POT & _po)
    {

        for (unsigned j = 0; j < _po.size (); j++)
        {
            double sigma=rng.uniform(1);

            if (sigma < sigmoid(_po.velocities[j]))
                _po[j]=1;
            else
                _po[j]=0;
        }

        // invalidate the fitness because the positions have changed
        _po.invalidate();
    }
};



#endif /*EOSIGBINARYFLIGHT_H */
