//-----------------------------------------------------------------------------
// t-eoNonUniform.cc
//-----------------------------------------------------------------------------

#include <iostream>      
#include <eo>

//-----------------------------------------------------------------------------

main()
{
  eoNonUniform nu(1000);

  std::cout << "----------------------------------------------------------" << std::endl
       << "nu.step() = " << nu.step()
       << "\t nu.num_step() = " << nu.num_step() << std::endl
       << "----------------------------------------------------------" << std::endl;
  
  eoLinear l1(0, 1, nu), l2(1, 0, nu);
  eoNegExp2 n1(0.1, 8, nu), n2(0.75, 3, nu);
  
  for (; nu; ++nu)
    {      
      std::cout << nu.step() 
	   << "\t" << l1() << "\t" << l2()
	   << "\t" << n1() << "\t" << n2()  
	   << std::endl;
    }
}

//-----------------------------------------------------------------------------
